<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fpaexp="http://bosch.com/fpaexport/XSLT">
  <xsl:output method="xml" indent="yes"/>
  <xsl:param name="ExportFiles">ExportFiles.xml</xsl:param>
  <!--##############  BEGIN Namspace fpaexp   ####################-->
  <fpaexp:Stylesheet version="$Revision: 1.6 $"/>
  <!--##############  END Namspace fpaexp   ####################-->
  <xsl:template match="*">
    <xsl:element name="{name()}">
      <xsl:apply-templates select="@* | node()">
    </xsl:apply-templates>
    </xsl:element>
  </xsl:template>
  <!-- explicitly copy attributes -->
  <xsl:template match="@*">
    <xsl:copy/>
  </xsl:template>
  <!-- read the root -->
  <xsl:template match="/FPA_CONFIG_EXPORT">
    <xsl:element name="ConfigObjects">
      <xsl:element name="ExportInfo">
        <xsl:call-template name="MakeExportInfo"/>
      </xsl:element>
      <xsl:element name="ConfigInfo">
        <xsl:call-template name="MakeConfigInfo"/>
      </xsl:element>
      <xsl:element name="Cluster">
        <xsl:call-template name="MakeCluster"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- make ExportInfo -->
  <xsl:template name="MakeExportInfo">
    <xsl:apply-templates select="/FPA_CONFIG_EXPORT/ExportInfo/*"/>
  </xsl:template>
  <!-- make ConfigInfo -->
  <xsl:template name="MakeConfigInfo">
    <xsl:apply-templates select="/FPA_CONFIG_EXPORT/ConfigInfo/*"/>
  </xsl:template>
  <!-- read the root -->
  <xsl:template name="MakeCluster">
    <xsl:for-each select="/FPA_CONFIG_EXPORT/Network/Nodes/NodeEntry[LocalData = true()]">
      <xsl:element name="System">
        <xsl:variable name="NodeID">
          <xsl:value-of select="@nodeID"/>
        </xsl:variable>
        <xsl:attribute name="Name"><xsl:value-of select="$NodeID"/></xsl:attribute>
        <xsl:attribute name="Type"><xsl:value-of select="NodeInfo/nodeType"/></xsl:attribute>
        <xsl:for-each select="LocalData/Addresses/AddressEntry">
          <xsl:call-template name="TryMakeObject">
            <xsl:with-param name="PNodeID">
              <xsl:value-of select="$NodeID"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:for-each>
      </xsl:element>
    </xsl:for-each>
  </xsl:template>
  <!-- make the object if conditions are true -->
  <xsl:template name="TryMakeObject">
    <xsl:param name="PNodeID"/>
    <xsl:variable name="ObjectID">
      <xsl:value-of select="$PNodeID"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="Logical/SIType/@numeric"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="Logical/siNumber"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="Logical/subNumber"/>
    </xsl:variable>
    <xsl:choose>
      <!-- NO internal Modules -->
      <xsl:when test="Logical/SIType/enum = 'MP_SI_MODULE' and Logical/siNumber &gt; 50">
        <xsl:comment>
          <xsl:value-of select="@logicalID"/>
          <xsl:text> - internal module skipped</xsl:text>
        </xsl:comment>
      </xsl:when>
      <!-- NO Points > 60000 -->
      <xsl:when test="Logical/SIType/enum = 'MP_SI_POINT' and Logical/siNumber &gt; 59999">
        <xsl:comment>
          <xsl:value-of select="@logicalID"/>
          <xsl:text> - skipped</xsl:text>
        </xsl:comment>
      </xsl:when>
      <!-- NO STATUS > 60000 -->
      <xsl:when test="Logical/SIType/enum = 'MP_SI_STATUS' and Logical/siNumber &gt; 59999">
        <xsl:comment>
          <xsl:value-of select="@logicalID"/>
          <xsl:text> - skipped</xsl:text>
        </xsl:comment>
      </xsl:when>
      <!-- SI_TYPES which are not exported -->
      <xsl:when test="Logical/SIType/enum = 'MP_SI_USER' or Logical/SIType/enum = 'MP_SI_TRANSFER' or Logical/SIType/enum = 'MP_SI_DIAGNOSTICS' or Logical/SIType/enum = 'MP_SI_HISTORY' or Logical/SIType/enum = 'MP_SI_ALARMCOUNTER' or Logical/SIType/enum = 'MP_SI_LOOP_SET' or Logical/SIType/enum = 'MP_SI_REDUNDANT_TRANSFER' or Logical/SIType/enum = 'MP_SI_FBF' or Logical/SIType/enum = 'MP_SI_VIRTUAL' or Logical/SIType/enum = 'MP_SI_TC_CHANNEL' or Logical/SIType/enum = 'MP_SI_DOWNLOAD'">
        <xsl:comment>
          <xsl:value-of select="@logicalID"/>
          <xsl:text> - skipped</xsl:text>
        </xsl:comment>
      </xsl:when>
      <!-- ERROR if MP_FT_UNDEFINED detected-->
      <xsl:when test="FunctionType/enum = 'MP_FT_UNDEFINED'">
		<xsl:choose>
		  <xsl:when test="Logical/SIType/enum = 'MP_SI_FAT'">
			  <!-- special handling for FAT: it is known that the sub-addresses > 0 have the function-type MP_FT_UNDEFINED intentionally
					they shall not be transmitted -->
			<xsl:comment>
			  <xsl:value-of select="@logicalID"/>
			  <xsl:text> - skipped</xsl:text>
			</xsl:comment>
		  </xsl:when>
		  <xsl:otherwise>
			<xsl:comment>
			  <xsl:value-of select="@logicalID"/>
			  <xsl:text> - MISSING FUNCTIONTYPE IN TRANSFORMER</xsl:text>
			</xsl:comment>
			<xsl:call-template name="MakeObject">
			  <xsl:with-param name="PObjectID">
				<xsl:value-of select="$ObjectID"/>
			  </xsl:with-param>
			</xsl:call-template>
		  </xsl:otherwise>
		</xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="MakeObject">
          <xsl:with-param name="PObjectID">
            <xsl:value-of select="$ObjectID"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- just make the object without condition -->
  <xsl:template name="MakeObject">
    <xsl:param name="PObjectID"/>
    <xsl:variable name="LogicalID">
      <xsl:value-of select="@logicalID"/>
    </xsl:variable>
    <xsl:element name="Object">
      <xsl:attribute name="Name"><xsl:value-of select="$PObjectID"/></xsl:attribute>
      <xsl:attribute name="Type"><xsl:value-of select="FunctionType/enum"/></xsl:attribute>
      <xsl:attribute name="DisplayName">
      <xsl:value-of select="../../Labels/LabelEntry[@logicalID = $LogicalID]/label"/>
      </xsl:attribute>
      <xsl:choose>
		<xsl:when test="(Logical/SIType/enum = 'MP_SI_POINT') or (Logical/SIType/enum = 'MP_SI_NAC') or (Logical/SIType/enum = 'MP_SI_FIREEXTINGUISHER')">
			<!-- for some SI-types the ZoneProperty is written -->
		  <xsl:attribute name="ZoneProperty">
			<xsl:choose>
			  <xsl:when test="PropertyFlags/flag = 'MP_PROP_GROUP'">Zone</xsl:when>
			  <xsl:otherwise>ZonePoint</xsl:otherwise>
			</xsl:choose>
		  </xsl:attribute>
		</xsl:when>
		<xsl:otherwise>
			<!-- for other types nothing is done -->
		</xsl:otherwise>
	  </xsl:choose>
    </xsl:element>
  </xsl:template>
</xsl:stylesheet>
